#version 330
#extension GL_EXT_gpu_shader4 : enable
//Magic MarbleMod01.fsh  by   duvengar

//https://www.shadertoy.com/view/XdXfWj
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//// COLORS ////

const vec3 ORANGE = vec3(1.0, 0.6, 0.2);
const vec3 PINK   = vec3(0.7, 0.1, 0.2); 
const vec3 BLUE   = vec3(0.4, 0.2, 0.9);
const vec3 GREEN  = vec3(0.1, 0.9, 0.4); 
const vec3 BLACK  = vec3(0.0, 0.0, 0.3);

///// NOISE /////

float hash( float n ) {
    return fract(sin(n)*43758.5453123);   
}


float noise( in vec2 x ){
    vec2 p = floor(x);
    vec2 f = fract(x);
    f = f * f * (3.0 - 2.0 * f);
    float n = p.x + p.y * 57.0;
    return mix(mix( hash(n + 0.0), hash(n + 1.0), f.x), mix(hash(n + 57.0), hash(n + 58.0), f.x), f.y);
}

////// FBM ////// 

mat2 m = mat2( 0.6, 0.6, -0.6, 0.8);
float fbm(vec2 p){
 
    float f = 0.0;
    f += 0.5000 * noise(p); p *= m * 2.02;
    f += 0.2500 * noise(p); p *= m * 2.03;
    f += 0.1250 * noise(p); p *= m * 2.01;
    f += 0.0625 * noise(p);
    f /= 0.9375;
    return f;
}

void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
    
    // pixel ratio
    
	vec2 uv = gl_FragCoord.xy / iResolution.xy;   
    vec2 p = - 1. + 2. * uv;  
    p.x *= iResolution.x / iResolution.y ;
    
    // ZOOM
    
    p *= abs(cos(iTime  * 0.17));
    
    // domains
    
    float r = sqrt(dot(p,p)); 
    float tetha = atan(p.x, p.y)  ;   
     
    float alpha = r * 0.2 + atan(dot(0.5, pow(abs(p.x), p.y)), dot(0.5, pow(abs(p.x),p.y))) - (iTime * 0.1); 
    tetha += - (iTime * 0.2);
                  
    // distortion
     
    alpha +=  1.4 + fbm( 1.7 * p) ;
   
  	
    // colorize
    
    vec3 col = BLACK;
    
    float ff = 1.0 - smoothstep( 0.2, 0.5, fbm(vec2( alpha * 20.0 , r * 3.)));        
    col =  mix( col, ORANGE, ff );
    
    ff = smoothstep(0.5, 0.9, fbm(vec2(alpha * 20.0 , r * 3.0)));  
    col =  mix( col, BLUE, ff); 
    
    ff = smoothstep(0.4, 0.9, fbm(vec2(alpha * 8.0 , r )));  
    col =  mix( col, PINK, ff ); 
    
    ff = smoothstep(0.6, 0.7, fbm(vec2(alpha * 18.0 , r / 2. )));  
    col =  mix( col, GREEN, ff * 0.6 ); 
    
    ff = smoothstep(0.3, 0.6, fbm(vec2(alpha * 100.0 , r * 7. )));  
    col *=  1.8 - ff ; 
    
    
    
    ff = smoothstep(0.9, 0.0, length(p - vec2(0.4,0.4)));  
    col =  mix( col, vec3(1.), ff * 0.6);
    
    ff = smoothstep(0.5, 0.0, length(p - vec2(0.4,0.4)));  
    col =  mix( col, vec3(1.), ff * 0.6 );
    
    ff = smoothstep(0.2, 0.0, length(p - vec2(0.4,0.4)));  
    col =  mix( col, vec3(1.), ff * 0.3);   
    
    ff = smoothstep(0.3, 1.6, fbm(vec2(tetha * 6., 3.)));  
    col +=  mix( BLACK, col, ff * 0.3);
    
    ff = smoothstep(0.3, 1.6, fbm(vec2(tetha * 56., r *10.)));  
    col +=   ff * 0.2;
   
    ff = smoothstep(0.7, 0.99, length(p));  
    col *=  mix(col, vec3(0.), ff);
    
    ff = smoothstep(0.7, 0.9, length(p - vec2(0.4,0.4)));  
    col *=  mix(col, vec3(0.), ff*0.6  );

    gl_FragColor = vec4(col, 1.);
}